//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct stComplex
{
//+----------------+
    private :
        double m_r, m_i;
//+----------------+
    public  :
//+----------------+
        stComplex(): m_r(0), m_i(0) {}
//+----------------+
        stComplex(double r): m_r(r), m_i(0) {}
//+----------------+
        stComplex(double r, double i): m_r(r), m_i(i) {}
//+----------------+
        stComplex operator+(const double arg)
        {
            return stComplex(m_r + arg, m_i);
        }
//+----------------+
        stComplex operator+=(const double arg)
        {
            return stComplex(m_r += arg, m_i);
        }
//+----------------+
        bool operator<(const double arg)
        {
            return (m_r < arg);
        }
//+----------------+
        bool operator>(const double arg)
        {
            return (m_r > arg);
        }
//+----------------+
        stComplex operator+(const stComplex &arg)
        {
            return stComplex(m_r + arg.m_r, m_i + arg.m_i);
        }
//+----------------+
        stComplex operator+=(const stComplex &arg)
        {
            return stComplex(m_r += arg.m_r, m_i += arg.m_i);
        }
//+----------------+
        bool operator<(const stComplex &arg)
        {
            return ((m_r < arg.m_r) ? true : (m_r > arg.m_r ? false : (m_i < arg.m_i)));
        }
//+----------------+
        bool operator>(const stComplex &arg)
        {
            return ((m_r > arg.m_r) ? true : (m_r < arg.m_r ? false : (m_i > arg.m_i)));
        }
//+----------------+
        bool operator&&(const stComplex &arg)
        {
            return m_r && arg.m_r && m_i && arg.m_i;
        }
//+----------------+
        stComplex operator&(const stComplex &arg)
        {
            union u1
            {
                double p64;
                ulong  u64;
            }v_r0, v_i0, v_r1, v_i1;

            v_r0.p64 = m_r;
            v_i0.p64 = m_i;
            v_r1.p64 = arg.m_r;
            v_i1.p64 = arg.m_i;

            v_r0.u64 &= v_r1.u64;
            v_i0.u64 &= v_i1.u64;

            return stComplex(v_r0.p64, v_i0.p64);
        }
//+----------------+
        string ToString(void)
        {
            return StringFormat("%.02f %c %.02fi", m_r, (m_i < 0 ? '-' : '+'), MathAbs(m_i));
        }
//+----------------+
        stComplex Debug(uint arg)
        {
            Print("Debugging the line ", arg, " = ", this.ToString());
            return this;
        }
//+----------------+
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    stComplex   a(15, 49),
                b(7, 25);
    Print("Variable A: ", a.ToString());
    Print("Variable B: ", b.ToString());
    Print("The result of A & B is: ", (a & b).ToString());
    Print("The result of A && B is: ", (a && b ? "TRUE" : "FALSE"));
}
//+------------------------------------------------------------------+
//         stComplex operator&(const stComplex &arg)
//         {
//             union u1
//             {
//                 double p64;
//                 ulong  u64;
//             }v_r0, v_i0, v_r1, v_i1, v_r2, v_i2;

//             v_r0.p64 = m_r;
//             v_i0.p64 = m_i;
//             v_r1.p64 = arg.m_r;
//             v_i1.p64 = arg.m_i;

//             // v_r2.u64 = v_r0.u64 & v_r1.u64;
//             // v_i2.u64 = v_i0.u64 & v_i1.u64;
//             v_r2 = v_r0;
//             v_i2 = v_i0;
//             // v_r2.u64 &= v_r1.u64;
//             // v_i2.u64 &= v_i1.u64;
//             v_r2.u64 &= ulong(arg.m_r);
//             v_i2.u64 &= ulong(arg.m_i);
//             // PrintFormat("REAL >> %I64X  &  %I64X = %I64X", v_r0.u64, v_r1.u64, v_r2.u64);
//             // PrintFormat("IMAG >> %I64X  &  %I64X = %I64X", v_i0.u64, v_i1.u64, v_i2.u64);

//             return stComplex(v_r2.p64, v_i2.p64);
//         }
// //+----------------+